<?php

namespace App\Http\Controllers\Admin;

use App\Models\Gaji;
use App\Models\Absensi;
use App\Models\Karyawan;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;

class GajiController extends Controller
{
    public function index()
    {
        $karyawan = Karyawan::with('user')->get();
        $gaji = Gaji::with('karyawan.user')->latest()->get();

        return view('admin.gaji.index', compact('karyawan','gaji'));
    }

    public function create()
    {
        $karyawan = Karyawan::with(['user', 'jabatan'])->get();

        return view('admin.gaji.create', compact('karyawan'));
    }

    public function hitung(Request $request)
    {
        $request->validate([
            'karyawan_id' => 'required',
            'bulan' => 'required',
            'tahun' => 'required'
        ]);

        //  cegah dobel hitung
        if (Gaji::where([
            'karyawan_id' => $request->karyawan_id,
            'bulan' => $request->bulan,
            'tahun' => $request->tahun
        ])->exists()) {
            return back()->with('error','Gaji bulan ini sudah dihitung');
        }

    $karyawan = Karyawan::with('jabatan')->findOrFail($request->karyawan_id);

        // hitung hadir
        $totalHadir = Absensi::where('karyawan_id',$karyawan->id)
            ->whereMonth('tanggal',$request->bulan)
            ->whereYear('tanggal',$request->tahun)
            ->whereNotNull('jam_masuk')
            ->count();

        $gajiHarian = $karyawan->jabatan->gaji_harian;
        $totalGaji = $totalHadir * $gajiHarian;

        Gaji::create([
            'karyawan_id' => $karyawan->id,
            'bulan' => $request->bulan,
            'tahun' => $request->tahun,
            'total_hadir' => $totalHadir,
            'gaji_harian' => $gajiHarian,
            'total_gaji' => $totalGaji,
            'tanggal_hitung' => now()
        ]);

        return back()->with('success','Gaji berhasil dihitung');
    }

    public function slip($id)
{
    $gaji = Gaji::with([
        'karyawan.user',
        'karyawan.jabatan'
    ])->findOrFail($id);

    $absensi = Absensi::where('karyawan_id', $gaji->karyawan_id)
        ->whereMonth('tanggal', $gaji->bulan)
        ->whereYear('tanggal', $gaji->tahun)
        ->where('status', 'hadir')
        ->get();

    return view('admin.gaji.slip_pdf', compact('gaji', 'absensi'));
}

public function downloadSlip($id)
{
    $gaji = Gaji::with([
        'karyawan.user',
        'karyawan.jabatan'
    ])->findOrFail($id);

    $pdf = Pdf::loadView('admin.gaji.slip_pdf', compact('gaji'))
        ->setPaper('A4', 'portrait');

    $fileName = 'Slip-Gaji-' .
        $gaji->karyawan->user->nama . '-' .
        $gaji->bulan . '-' .
        $gaji->tahun . '.pdf';

    return $pdf->download($fileName);
}

public function slipPdf($id)
{
    $gaji = Gaji::with([
        'karyawan.user',
        'karyawan.jabatan'
    ])->findOrFail($id);

    $absensi = Absensi::where('karyawan_id', $gaji->karyawan_id)
        ->whereMonth('tanggal', $gaji->bulan)
        ->whereYear('tanggal', $gaji->tahun)
        ->where('status', 'hadir')
        ->get();

    $pdf = Pdf::loadView('admin.gaji.slip_pdf', compact('gaji', 'absensi'))
        ->setPaper('A4', 'portrait');

    $fileName = 'Slip-Gaji-' . $gaji->karyawan->user->nama . '-' . $gaji->bulan . '-' . $gaji->tahun . '.pdf';

    return $pdf->download($fileName);
}

}
